package com.agilex.healthcare.utility;

import java.util.Iterator;

import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.parser.Parser;
import org.jsoup.safety.Cleaner;
import org.jsoup.safety.Whitelist;

public class XSSValidator {
    public static boolean hasXSSInjection(String input){
        if (input == null || new Cleaner( Whitelist.basic()).isValid( getFragmentAsDocument( input ))){
            return false;
        }
        return true;
    }

    protected static Document getFragmentAsDocument(CharSequence value) {
        Document fragment = Jsoup.parse( value.toString(), "", Parser.xmlParser() );
        Document document = Document.createShell( "" );

        // add the fragment's nodes to the body of resulting document
        Iterator<Element> nodes = fragment.children().iterator();
        while ( nodes.hasNext() ) {
            document.body().appendChild( nodes.next() );
        }

        return document;
    }


}
